<?php
/**************************************************************************
 *                                                                        *
 *    4images - A Web Based Image Gallery Management System               *
 *    ----------------------------------------------------------------    *
 *                                                                        *
 *             File: update_RC-1_to_RC-2.php                              *
 *        Copyright: (C) 2002 Jan Sorgalla                                *
 *            Email: jan@4homepages.de                                    *
 *              Web: http://www.4homepages.de                             *
 *    Scriptversion: 1.7                                                  *
 *                                                                        *
 *    Never released without support from: Nicky (http://www.nicky.net)   *
 *                                                                        *
 **************************************************************************
 *                                                                        *
 *    Dieses Script ist KEINE Freeware. Bitte lesen Sie die Lizenz-       *
 *    bedingungen (Lizenz.txt) fr weitere Informationen.                 *
 *    ---------------------------------------------------------------     *
 *    This script is NOT freeware! Please read the Copyright Notice       *
 *    (Licence.txt) for further information.                              *
 *                                                                        *
 *************************************************************************/
$templates_used = 'home,category_bit,whos_online,thumbnail_bit';
$main_template = 'home';

define('GET_CACHES', 1);
define('ROOT_PATH', './');
define('GET_USER_ONLINE', 1);
include(ROOT_PATH.'global.php');
require(ROOT_PATH.'includes/sessions.php');
$user_access = get_permission();

if (isset($HTTP_GET_VARS['template']) || isset($HTTP_POST_VARS['template'])) {
  $template = (isset($HTTP_GET_VARS['template'])) ? stripslashes(trim($HTTP_GET_VARS['template'])) : stripslashes(trim($HTTP_POST_VARS['template']));
  if (!file_exists(TEMPLATE_PATH."/".$template.".".$site_template->template_extension)) {
    $template = "";
  }
  else {
    $main_template = $template;
  }
}
else {
  $template = "";
}
include(ROOT_PATH.'includes/page_header.php');

if (!empty($template)) {
  $clickstream = "<a href=\"".$site_sess->url(ROOT_PATH."index.php")."\">".$lang['home']."</a>".$config['category_separator'].str_replace("_", " ", ucfirst($template));
  $site_template->register_vars("clickstream", $clickstream);
  $site_template->print_template($site_template->parse_template($main_template));
  include(ROOT_PATH.'includes/page_footer.php');
}

//-----------------------------------------------------
//--- Show Categories ---------------------------------
//-----------------------------------------------------
$categories = get_categories(0);
if (!$categories)  {
  $categories = $lang['no_categories'];
}
$site_template->register_vars("categories", $categories);
unset($categories);

//-----------------------------------------------------
//--- Show New Images ---------------------------------
//-----------------------------------------------------
$imgtable_width = ceil(intval($config['image_table_width']) / $config['image_cells']);
if ((substr($config['image_table_width'], -1)) == "%") {
  $imgtable_width .= "%";
}

$additional_sql = "";
if (!empty($additional_image_fields)) {
  foreach ($additional_image_fields as $key => $val) {
    $additional_sql .= ", i.".$key;
  }
}

$num_new_images = $config['image_cells'];
$sql = "SELECT i.image_id, i.cat_id, i.user_id, i.image_name, i.image_description, i.image_keywords, i.image_date, i.image_active, i.image_media_file, i.image_thumb_file, i.image_download_url, i.image_allow_comments, i.image_comments, i.image_downloads, i.image_votes, i.image_rating, i.image_hits".$additional_sql.", c.cat_name".get_user_table_field(", u.", "user_name")." 
        FROM ".IMAGES_TABLE." i,  ".CATEGORIES_TABLE." c
        LEFT JOIN ".USERS_TABLE." u ON (".get_user_table_field("u.", "user_id")." = i.user_id) 
        WHERE i.image_active = 1 AND c.cat_id = i.cat_id AND i.cat_id IN (".get_auth_cat_sql("auth_viewcat").") 
        ORDER BY i.image_date DESC 
        LIMIT $num_new_images";
$result = $site_db->query($sql);
$num_rows = $site_db->get_numrows($result);

if (!$num_rows)  {
  $new_images = "<table width=\"".$config['image_table_width']."\" border=\"0\" cellpadding=\"".$config['image_table_cellpadding']."\" cellspacing=\"".$config['image_table_cellspacing']."\"><tr class=\"imagerow1\"><td>";
  $new_images .= $lang['no_new_images'];
  $new_images .= "</td></tr></table>";
}
else  {
  $new_images = "<table width=\"".$config['image_table_width']."\" border=\"0\" cellpadding=\"".$config['image_table_cellpadding']."\" cellspacing=\"".$config['image_table_cellspacing']."\">";
  $count = 0;
  $bgcounter = 0;
  while ($image_row = $site_db->fetch_array($result)){
    if ($count == 0) {
      $row_bg_number = ($bgcounter++ % 2 == 0) ? 1 : 2;
      $new_images .= "<tr class=\"imagerow".$row_bg_number."\">\n";
    }
    $new_images .= "<td width=\"".$imgtable_width."\" valign=\"top\">\n";

    show_image($image_row);
    $new_images .= $site_template->parse_template("thumbnail_bit");
    $new_images .= "\n</td>\n";
    $count++;
    if ($count == $config['image_cells']) {
      $new_images .= "</tr>\n";
      $count = 0;
    }
  } // end while

  if ($count > 0)  {
    $leftover = ($config['image_cells'] - $count);
    if ($leftover >= 1) {
      for ($f = 0; $f < $leftover; $f++) {
        $new_images .= "<td width=\"".$imgtable_width."\">\n&nbsp;\n</td>\n";
      }
      $new_images .= "</tr>\n";
    }
  }
  $new_images .= "</table>\n";
} // end else

$site_template->register_vars("new_images", $new_images);
unset($new_images);
$additional_sql = "";
      $table_fields = $site_db->get_table_fields(USERS_TABLE);
      foreach ($additional_user_fields as $key => $val) {
        if (isset($HTTP_POST_VARS[$key]) && isset($table_fields[$key])) {
          $additional_sql .= ", $key = '".un_htmlspecialchars(trim($HTTP_POST_VARS[$key]))."'";
        }
      }
 if (isset($HTTP_GET_VARS['user_id']) and $HTTP_GET_VARS['user_id'] != ""){
   $add_where = "WHERE c.user_id IN (".$user_id.")";
  }else{
   $add_where = "";
  }
  $sql = "SELECT c.comment_id, c.image_id, c.user_id, c.user_name AS comment_user_name, c.comment_headline, c.comment_text, c.comment_date".get_user_table_field(", u.", "user_level").get_user_table_field(", u.", "user_name").get_user_table_field(", u.", "user_lastaction").get_user_table_field(", u.", "user_comments").$additional_sql."
          FROM ".COMMENTS_TABLE." c
          LEFT JOIN ".USERS_TABLE." u ON (".get_user_table_field("u.", "user_id")." = c.user_id)
        ".$add_where."
          ORDER BY c.comment_date DESC
        LIMIT 3";
  $result = $site_db->query($sql);
  $comment_row = array(); 
  while ($row = $site_db->fetch_array($result)) {
    $comment_row[] = $row;
  }
  $site_db->free_result($result);
  $num_comments = sizeof($comment_row);
  if (!$num_comments) {
    $comments_short = "<tr><td class=\"commentrow1\" colspan=\"2\">".$lang['no_comments']."</td></tr>";
  }
  else {
    $comments_short = "";
    for ($i = 0; $i < $num_comments; $i++) {
      $image_id = $comment_row[$i]['image_id'];
      $sql = "SELECT i.image_id, i.cat_id, i.image_name, c.cat_name, i.image_media_file, i.image_thumb_file
            FROM ".IMAGES_TABLE." i,  ".CATEGORIES_TABLE." c
            LEFT JOIN ".USERS_TABLE." u ON (".get_user_table_field("u.", "user_id")." = i.user_id)
            WHERE i.image_id = $image_id AND c.cat_id = i.cat_id";
      $image_row = $site_db->query_firstrow($sql);
      $cat_id = (isset($image_row['cat_id'])) ? $image_row['cat_id'] : 0;
     if (check_permission("auth_readcomment", $cat_id)){
      $comment_user_name = htmlspecialchars($comment_row[$i]['comment_user_name']);
      $comment_user_info = $lang['userlevel_guest'];
      $comment_user_id = $comment_row[$i]['user_id'];
      $user_row_comment = get_user_info($comment_user_id);
      $comment_user_profile_link = "";
      $comment_user_info = $lang['userlevel_guest'];
        if (!isset($comment_row[$i][$user_table_fields['user_level']]) || (isset($comment_row[$i][$user_table_fields['user_level']]) && $comment_row[$i][$user_table_fields['user_level']] == USER)) {
          $comment_user_info = $lang['userlevel_user'];
        }
        elseif ($comment_row[$i][$user_table_fields['user_level']] == ADMIN) {
          $comment_user_info = $lang['userlevel_admin'];
        }
      if (isset($comment_row[$i][$user_table_fields['user_name']]) && $comment_user_id != GUEST) {
        $comment_user_name = htmlspecialchars($comment_row[$i][$user_table_fields['user_name']]);
        $comment_user_profile_link = !empty($url_show_profile) ? $site_sess->url(preg_replace("/{user_id}/", $comment_user_id, $url_show_profile)) : $site_sess->url(ROOT_PATH."member.php?action=showprofile&amp;".URL_USER_ID."=".$comment_user_id);
      }
        $comment_user_profile_link = ($comment_user_profile_link) ? "<a href=\"".$comment_user_profile_link."\">".$comment_user_name."</a>" : $comment_user_name;
       if (!get_file_path($image_row['image_thumb_file'], "thumb", $image_row['cat_id'], 0, 0)) {
        $thumb_file = ICON_PATH."/".get_file_extension($image_row['image_media_file']).".gif";
      }else {
        $thumb_file = get_file_path($image_row['image_thumb_file'], "thumb", $image_row['cat_id'], 0, 1);
      }
      $thumb_info = @getimagesize($thumb_file);
      $width = $thumb_info[0];
      $height = $thumb_info[1];
      $dimension = 40;
      $ratio = $width / $height;
      if ($ratio > 1) {
        $new_width = $dimension;
        $new_height = floor(($dimension/$width) * $height);
      }else {
        $new_width = floor(($dimension/$height) * $width);
        $new_height = $dimension;
      }
      $site_template->register_vars(array(
         "comment_image_thumb" => (!check_permission("auth_viewcat", $cat_id) || !check_permission("auth_viewimage", $cat_id)) ? "<img src=\"".$thumb_file."\" width=\"".$new_width."\" height=\"".$new_height."\" onClick=\"alert('".$lang['members_only']."');\" border=\"".$config['image_border']."\">" : "<a href=\"".$site_sess->url(ROOT_PATH."details.php?".URL_IMAGE_ID."=".$comment_row[$i]['image_id'].((!empty($mode)) ? "&amp;mode=".$mode : ""))."\"><img src=\"".$thumb_file."\" width=\"".$new_width."\" height=\"".$new_height."\" border=\"".$config['image_border']."\"></a>",
        "comment_image_name" => (!check_permission("auth_viewcat", $cat_id) || !check_permission("auth_viewimage", $cat_id)) ? $image_row['image_name'] : "<a href=\"".$site_sess->url(ROOT_PATH."details.php?".URL_IMAGE_ID."=".$comment_row[$i]['image_id'].((!empty($mode)) ? "&amp;mode=".$mode : ""))."\">".$image_row['image_name']."</a>",
        "comment_cat_name" => (!check_permission("auth_viewcat", $cat_id)) ? $image_row['cat_name'] : "<a href=\"".$site_sess->url(ROOT_PATH."categories.php?".URL_CAT_ID."=".$cat_id)."\">".$image_row['cat_name']."</a>",
        "comment_user_name" => $comment_user_profile_link,
        "comment_user_info" => $comment_user_info,
        "comment_headline" => format_text($comment_row[$i]['comment_headline'], 0, $config['wordwrap_comments'], 0, 0),
        "comment_text" => format_text($comment_row[$i]['comment_text'], $config['html_comments'], $config['wordwrap_comments'], $config['bb_comments'], $config['bb_img_comments']),
        "comment_date" => format_date($config['date_format']." ".$config['time_format'], $comment_row[$i]['comment_date']),
      ));
      $comments_short .= $site_template->parse_template("comment_short_bit");
     }
    } // end while
  } //end else
  $site_template->register_vars("comments_short", $comments_short);
  unset($comments_short);
//-----------------------------------------------------
//--- Print Out ---------------------------------------
//-----------------------------------------------------
$site_template->register_vars(array(
  "msg" => $msg,
  "clickstream" => $clickstream
));
$site_template->print_template($site_template->parse_template($main_template));
include(ROOT_PATH.'includes/page_footer.php');
?>
